
markup.push({

	// --------------------------------------------------------
	// MARK: - preferences window

	PreferencesEditorDropView: {		// referenced in Prefs window .xib
		nsClass: "GXDropView",
		acceptDroppedApps: true,
		gxValueKey: "droppedApps",
		gxHilitePainter: "DropHilitePainter",
	},

	DropHilitePainter:
	{
		nsClass: "GXPainter",
		gxStrokeWidth: 3,
		gxCornerRadius: 10,
		gxFrameColor: "SelectionColor2.noBlockDisabled",
	},

	ImageView: {
		nsClass: "GXDrawView",
		gxForePainter: "ImagePainter",
		gxIntrinsicHeight: 16,
		gxIntrinsicWidth: 16,
	},

	InfoIcon: {
		nsClass: "GXDrawView",
		gxForePainter: "ImagePainter.foreColor2.info-icon",
		gxIntrinsicHeight: 16,
		gxIntrinsicWidth: 16,
	},


	// -------------------------------------------------
	// MARK: popup menu template

	PopupMenuTemplate: {
		"+": "PopupMenuView",
		gxLabelTemplate: "LabelView.right.size13",
		gxHideOnNilValue: true
	},

	// -------------------------------------------------
	// MARK: checkbox template

	CheckboxTemplate:
    {
		nsClass: "GXButtonView",
		//gxIconBaseName: "checkbox",
        gxButtonType: "checkbox",
        gxForePainter: {
			"+": "ControlFore.useMarkup.left",
			on: {
					// nothing - needed to avoid title color change of button
			}
		},
		gxIntrinsicHeight: 23,
		gxBaselineOffset: 6,
		gxFocusRingPainter: {
			nsClass: "GXPainter",
			gxFillColor: "BlackColor",
			gxCornerRadius: 5,
			gxEdgeInsets: "0, 0, 1, 2",  // adjust to center better with checkbox
		},
		gxLabelTemplate: "LabelView.right.size13"
	},

	
	// -------------------------------------------------
	// MARK: checkbox template

	PlusButton: {
		"+": "ButtonView",
		gxForePainter: "ControlFore.useMarkup.left",
		gxBackPainter: null,
		gxTitle: "<plusButton/>",
	},
	
	MinusButton: {
		"+": "ButtonView",
		gxForePainter: "ControlFore.useMarkup.left",
		gxBackPainter: null,
		gxTitle: "<minusButton/>",
		gxDisableOnNil: true,
	},

	// -------------------------------------------------
	// MARK: textfield templates

	ReadoutTextField: {
		nsClass: "GXNumberField",
		gxTextPainter: "ReadoutTextPainter",
		gxBackPainter: "ReadoutBg",
		gxIntrinsicHeight: 16,
		gxDisabledAlphaColor: colorMono(0, 28),
		gxInsertionPointColor: "WhiteColor",
		gxSelectionColor: "TextSelectionColor",
		gxDrawFocusRing: false,
	},

	ReadoutTextPainter: {
		"+": "LabelFore",
		gxBackColor: "BackColor2" // textfield's own fill color, should match painter fill
	},

	ReadoutBg: {
		nsClass: "GXPainter",
		gxCornerRadius: 3,
		editing: {
			gxFrameColor: "BackColor2",
		}
	},

	
	// -------------------------------------------------
	// MARK: textfield readout template

	TextPainter:
	{
		nsClass: "GXStringPainter",
		gxFontSize: 13,
		gxFontColor: "ForeColor1",
		//gxBackColor: "BackColor3",
		gxHAlign: 0,
		gxVAlign: 0,
		multiline: {
			gxLineBreakMode: 0,	// wrap
		},
	},

	BaseTextField:
	{
		nsClass: "GXTextField",
		gxIntrinsicHeight: 25,
		gxBaselineOffset: 6,
		gxTextPainter: "TextPainter",
		gxInsertionPointColor: "ForeColor1",
		gxSelectionColor: "TextSelectionColor",
		multiline: {
			gxIsSingleLine: false,
		},
	},

	DarkTextField:
	{
		"+": "BaseTextField",
		gxEdgeInsets: "2, 5, 2, 3",	// insets for text within the field's bounds.
									// which changes baseline offset, etc
		gxBackPainter: "ControlBack",
		gxPlaceholderStyle: "PlaceholderStyle.disabled",
		gxLabelTemplate: "LabelView.right.size13",
	},

	PlaceholderStyle:
	{
		nsClass: "GXStyledString",
		gxFontSize: 13,
		gxFontColor: "ForeColor1",
	},
	

	// MARK: token field template

	TokenField:
	{
		"+": "DarkTextField",
		nsClass: "GXTokenField",
		gxTokenTemplate: "TextTokenAttachment",
		gxButtonBackPainter:
		{
			nsClass: "GXPainter",
			gxCornerRadii: "0, 8, 8, 0",
			gxEdgeInsets: "0, 1, 1, 1",
			gxFillColor: "BackColor2",
		},
		gxButtonForePainter:
		{
			"+": "ImagePainter.token-menu",
			gxDefaultSize: "24, 22",	// required, sets button size
			gxEdgeInsets: "0, 2, 0, 0",
			gxTintColor: "ColorTheme1",
		},
	},

	TextTokenAttachment:
	{
		gxDefaultSize: "20, 16",	// token size. height always used, width used as minumum
		gxBaselineOffset: -3,		// height and baseline offset need to match line height of font
										// used in field to avoid vertical jump when field content
										// changes from a single token alone to token and text
		gxForePainter: {
			"+": "ControlFore",
			gxFontSize: 11.5,
			gxAlignment: "0.5, 0.5",
			gxEdgeInsets: "6,1,6,0",
			gxFontColor: "ForeColorTheme1"
		},
		gxBackPainter: {
			nsClass: "GXPainter",
			gxCornerRadius: 999,
			gxEdgeInsets: "1.5,1,1.5,0",
			//gxFrameColor: "ColorTheme2",
			gxFillColor: "ColorTheme1",
		},
	},

	// MARK: album art template

	ArtView: {
		nsClass: "GXArtView",
		gxBackPainter: "ControlBack",
		gxForePainter: "ArtViewFore",
		gxStrokeColor: "TextSelectionColor",	// for drag drop hilite
		gxDisabledAlphaColor: "BackColor3",
		noDefaultText: {
			gxForePainter: "",
		},
	},

	ArtViewFore: {
		"+": "ControlFore",
		gxLineBreakMode: 0,	// word wrap
		gxAlignment: "0.5, 0.5",
		gxFontColor: "ForeColor2",
		gxFontSize: 10,
		gxDefaultString: "Drag\n Artwork\n Here",
	},

	// MARK: list items background
	
	ListItemBack:
	{
		nsClass: "GXPainter",
		gxFillColor: "SidebarBackColor1",
		gxCornerRadius: 8,
		selected: {
			gxFillColor: "SelectionColor3",
		},
	},



})
